using System;
using Server.Items;
using Server.Mobiles;

namespace Server.Engines.Craft
{
	public class DefAquarium : CraftSystem
	{
		public override SkillName MainSkill
		{
			get{ return SkillName.Fishing; }
		}

		public override string GumpTitleString
		{
			get { return "<basefont color=#FFFFFF><CENTER>FISHER'S MENU</CENTER></basefont>"; } 
		}

		private static CraftSystem m_CraftSystem;

		public static CraftSystem CraftSystem
		{
			get
			{
				if ( m_CraftSystem == null )
					m_CraftSystem = new DefAquarium();

				return m_CraftSystem;
			}
		}

		public override double GetChanceAtMin( CraftItem item )
		{
			return 0.0; // 0%
		}

		private DefAquarium() : base( 1, 1, 1.25 )// base( 1, 2, 1.7 )
		{
		}

		public override int CanCraft( Mobile from, BaseTool tool, Type itemType )
		{
			if ( tool.Deleted || tool.UsesRemaining < 0 )
				return 1044038; // You have worn out your tool!
			else if ( !BaseTool.CheckAccessible( tool, from ) )
				return 1044263; // The tool must be on your person to use.

			return 0;
		}

		public override void PlayCraftEffect( Mobile from )
		{
			from.PlaySound( 0x1C6 ); 
		}

		private class InternalTimer : Timer
		{
			private Mobile m_From;

			public InternalTimer( Mobile from ) : base( TimeSpan.FromSeconds( 1.1 ) )
			{
				m_From = from;
            Priority = TimerPriority.OneSecond;
			}

			protected override void OnTick()
			{
				m_From.PlaySound( 0x1C6 );
			}
		}

		public override int PlayEndingEffect( Mobile from, bool failed, bool lostMaterial, bool toolBroken, int quality, bool makersMark, CraftItem item )
		{
			if ( toolBroken )
				from.SendLocalizedMessage( 1044038 );

			if ( failed )
			{
				if ( lostMaterial )
					return 1044043;
				else
					return 1044157;
			}
			else
			{
				from.PlaySound( 0x1c6 );

				if ( quality == 0 )
					return 502785;
				else if ( makersMark && quality == 2 )
					return 1044156;
				else if ( quality == 2 )
					return 1044155;
				else
					return 1044154;
			}
		}

		public override void InitCraftList()
		{
			int index = AddCraft( typeof( BladePlantSmallFishtankAddonDeed ), "Deco-Tanks", "Blade Plant", 60.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishBladePlant ), "Blade Plant", 5, "You need Blade Plant to make that" );

			index = AddCraft( typeof( CoralSmallFishtankAddonDeed ), "Deco-Tanks", "Coral", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishCoral ), "Coral", 5, "You need Coral to make that" );

			index = AddCraft( typeof( DeadFishSmallFishtankAddonDeed ), "Deco-Tanks", "Dead Fish", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishBones ), "Fish Bones", 10, "You need Fish Bones to make that" );

			index = AddCraft( typeof( EmptyFishtankAddonDeed ), "Deco-Tanks", "Empty Tank", 50.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );

			index = AddCraft( typeof( GhostShipAnchorSmallFishtankAddonDeed ), "Deco-Tanks", "Ghost Anchor", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( GhostShipAnchor ), 1070816, 1, "You need Ghost Ship Anchor to make that" );

			index = AddCraft( typeof( SunkenShipSmallFishtankAddonDeed ), "Deco-Tanks", "Sunken Ship", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( ShipModelOfTheHMSCape ), 1063476, 1, "You need Ship Model to make that" );

			index = AddCraft( typeof( TreasureChestSmallFishtankAddonDeed ), "Deco-Tanks", "Treasure Chest", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( GoldIngot ), "Gold Ingots", 15, 1044037 );

			index = AddCraft( typeof( WhitePearlSmallFishtankAddonDeed ), "Deco-Tanks", "White Pearl", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( WhitePearl ), "White Pearl", 1, 1044240 );

			index = AddCraft( typeof( AlbinoAngelfishSmallFishtankAddonDeed ), "Fish-Tanks", "Albino Angel", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishAlbinoAngelfish ), "Albino Angelfish", 10, "You need an Albino Angelfish to make that" );

			index = AddCraft( typeof( AngelfishSmallFishtankAddonDeed ), "Fish-Tanks", "Angel Fish", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishAngelfish ), "Angelfish", 10, "You need an Angelfish to make that" );

			index = AddCraft( typeof( BlueCorySmallFishtankAddonDeed ), "Fish-Tanks", "Blue Cory", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishBlueCory ), "Blue Cory", 10, "You need a Blue Cory to make that" );

			index = AddCraft( typeof( BrineShrimpSmallFishtankAddonDeed ), "Fish-Tanks", "Brine Shrimp", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishBrineShrimp ), "Brine Shrimp", 10, "You need a Brine Shrimp to make that" );

			index = AddCraft( typeof( BritainiaCrownFishSmallFishtankAddonDeed ), "Fish-Tanks", "Britania Crown", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishBritainiaCrownFish ), "Britainia Crown Fish", 10, "You need a Britainia Crown Fish to make that" );

			index = AddCraft( typeof( ClownfishSmallFishtankAddonDeed ), "Fish-Tanks", "Clown Fish", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishClownfish ), "Clownfish", 10, "You need a Clownfish to make that" );

			index = AddCraft( typeof( FandancerSmallFishtankAddonDeed ), "Fish-Tanks", "Fandancer Fish", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishFandancer ), "Fandancer fish", 10, "You need a Fandancer fish to make that" );

			index = AddCraft( typeof( FishiesSmallFishtankAddonDeed ), "Fish-Tanks", "Fishies", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishFishies ), "Fishies", 50, "You need a Fishies to make that" );

			index = AddCraft( typeof( GoldenBroadtailSmallFishtankAddonDeed ), "Fish-Tanks", "Golden Broad Tail", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishGoldenBroadtail ), "Golden Broadtail", 10, "You need a Golden Broadtail fish to make that" );

			index = AddCraft( typeof( JellyfishSmallFishtankAddonDeed ), "Fish-Tanks", "Jelly Fish", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishJellyfish ), "Jellyfish", 10, "You need a Jellyfish to make that" );

			index = AddCraft( typeof( MinocBlueSmallFishtankAddonDeed ), "Fish-Tanks", "Minoc Blue", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishMinocBlue ), "Minoc Blue Fish", 10, "You need a Minoc Blue fish to make that" );

			index = AddCraft( typeof( NujelmHoneySmallFishtankAddonDeed ), "Fish-Tanks", "Nujelm Honey", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishNujelmHoney ), "Nujelm Honey Fish", 10, "You need a Nujelm Honey fish to make that" );

			index = AddCraft( typeof( RainbowMollySmallFishtankAddonDeed ), "Fish-Tanks", "Rainbow Molly", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishRainbowMolly ), "Rainbow Molly Fish", 10, "You need a Rainbow Molly fish to make that" );

			index = AddCraft( typeof( ShrimpSmallFishtankAddonDeed ), "Fish-Tanks", "Shrimp", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishShrimp ), "Shrimp", 10, "You need a Shrimp to make that" );

			index = AddCraft( typeof( SmallMouthSuckerFishSmallFishtankAddonDeed ), "Fish-Tanks", "Smallmouth Sucker", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishSmallmouthSuckerfish ), "Smallmouth Suckerfish", 10, "You need a Smallmouth Suckerfish to make that" );

			index = AddCraft( typeof( SpeckledCrabSmallFishtankAddonDeed ), "Fish-Tanks", "Speckled Crab", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishSpeckledCrab ), "Speckled Crab", 10, "You need a Speckled Crab to make that" );

			index = AddCraft( typeof( SpottedBucaneerSmallFishtankAddonDeed ), "Fish-Tanks", "Spotted Bucaneer", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishSpottedBucaneer ), "Spotted Bucaneer Fish", 10, "You need a Spotted Bucaneer fish to make that" );

			index = AddCraft( typeof( SpottedPufferSmallFishtankAddonDeed ), "Fish-Tanks", "Spotted Puffer", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishSpottedPuffer ), "Spotted Puffer", 10, "You need a Spotted Puffer to make that" );

			index = AddCraft( typeof( StripedSosarianSwillSmallFishtankAddonDeed ), "Fish-Tanks", "Striped Sosarian", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishStripedSosarianSwill ), "Striped Sosarian Swill Fish", 10, "You need a Striped Sosarian Swill fish to make that" );

			index = AddCraft( typeof( VesperReefTigerSmallFishtankAddonDeed ), "Fish-Tanks", "Vesper Reef Tiger", 70.0, 95.0, typeof( Sand ), 1044625, 25, 1044627 );
			AddRes( index, typeof( BaseBeverage ), 1046458, 5, 1044253 );
			AddRes( index, typeof( FishVesperReefTiger ), "Vesper Reef Tiger Fish", 10, "You need a Vesper Reef Tiger fish to make that" );

			index = AddCraft( typeof( FishersKeg ),	"Ostatni", "rybarsky sak",		65.2, 100.2,	typeof( Log ), 1044041, 10, 1044351 );
			AddSkill( index, SkillName.Tailoring, 41.3, 55.0 );
			AddRes( index, typeof( FabledFishingNet ), 1063451, 1, 1044253 );
// 			AddRes( index, typeof( NetPiece ), "fishing net piece", 1, 1044253 );
			AddRes( index, typeof( MimicShard ), "mimic shard", 1, 1044253);
		}
	}
}